//
//  SecondViewController.m
//  ComAir5
//
//  Created by generalplus_sa1 on 10/22/14.
//  Copyright (c) 2014 generalplus_sa1. All rights reserved.
//

#import "SecondViewController.h"
#import <AVFoundation/AVFoundation.h>
#import <AudioToolbox/AudioToolbox.h>
#import <QuartzCore/QuartzCore.h>
#import "ComAir5API.h"
//----------------------------------------------------------------
@interface SecondViewController ()
{
    AVAudioPlayer       *m_audioPlayer;
    NSTimer				*m_AutoTestTimer;
}

@property (retain, nonatomic) IBOutlet UILabel *UICmdValue;
@property (retain, nonatomic) IBOutlet UIStepper *UICmdStepper;

@end
//----------------------------------------------------------------
@implementation SecondViewController
//-----------------------------------------------------------------
@synthesize UICmdValue,UICmdStepper;
//-----------------------------------------------------------------
-(IBAction)PressCmdStepper:(id)sender
{
    UICmdValue.text = [NSString stringWithFormat:@"%d",(int)UICmdStepper.value];
}
//-----------------------------------------------------------------
-(IBAction)PressSend:(id)sender
{
    if(m_audioPlayer!=nil)
    {
        m_audioPlayer =nil;
    }
    
    int i32cmd = (int)UICmdStepper.value;
    PlayComAir5Cmd(i32cmd,0.5);
    
    NSString *SoundIndex = [[NSString alloc]initWithFormat:@"n%d",i32cmd];
    NSString *soundFilePath = [[NSBundle mainBundle] pathForResource: SoundIndex ofType: @"wav"];
    NSURL *fileURL = [[NSURL alloc] initFileURLWithPath: soundFilePath];
    m_audioPlayer = [[AVAudioPlayer alloc]initWithContentsOfURL:fileURL error: nil];
    m_audioPlayer.numberOfLoops = 0;
    m_audioPlayer.volume = 0.5;
    [m_audioPlayer play];
     
    AudioServicesPlayAlertSound(kSystemSoundID_Vibrate);
}
//----------------------------------------------------------------
-(IBAction)PressAutoTest:(id)sender
{
    UISwitch *pSwitch = (UISwitch*)sender;
    
    if(pSwitch.isOn)
    {
        m_AutoTestTimer = [NSTimer scheduledTimerWithTimeInterval:2.0
                                                           target:self
                                                         selector:@selector(AutoTestCallback:)
                                                         userInfo:nil
                                                          repeats:YES];
    }
    else
    {
        if(m_AutoTestTimer)
        {
            [m_AutoTestTimer invalidate];
            m_AutoTestTimer = nil;
        }
    }
}
//-----------------------------------------------------------------
-(void) AutoTestCallback:(NSTimer*) timer
{
    if(m_audioPlayer!=nil)
    {
        m_audioPlayer =nil;
    }
    
    int i32cmd = (int)UICmdStepper.value;
    PlayComAir5Cmd(i32cmd,0.5);
    
    NSString *SoundIndex = [[NSString alloc]initWithFormat:@"n%d",i32cmd];
    NSString *soundFilePath = [[NSBundle mainBundle] pathForResource: SoundIndex ofType: @"wav"];
    NSURL *fileURL = [[NSURL alloc] initFileURLWithPath: soundFilePath];
    m_audioPlayer = [[AVAudioPlayer alloc]initWithContentsOfURL:fileURL error: nil];
    m_audioPlayer.numberOfLoops = 0;
    m_audioPlayer.volume = 0.5;
    [m_audioPlayer play];
    
    i32cmd++;
    i32cmd%=80;
    
    UICmdStepper.value = i32cmd;
    UICmdValue.text = [NSString stringWithFormat:@"%d",i32cmd];
}
//-----------------------------------------------------------------
- (void)viewWillAppear:(BOOL)animated
{
    StopComAir5Decode();
    
    [super viewWillAppear:animated];
}
//-----------------------------------------------------------------
- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    
    m_audioPlayer = nil;
    m_AutoTestTimer= nil;
}
//-----------------------------------------------------------------
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
//-----------------------------------------------------------------
- (BOOL)prefersStatusBarHidden {
    
    return true;
}
//-----------------------------------------------------------------
@end
